﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Data;
using System.Data.SqlClient;
using AZVIC.Ei8htPOS.Entities;
using AZVIC.Ei8htPOS.Utilities;

namespace AZVIC.Ei8htPOS.DAL
{
    public class ProductBrandDB
    {
        public static ProductBrand GetItem(Guid productBrandID, string keyword)
        {
            List<SqlParameter> parameters = new List<SqlParameter>();
            parameters.Add(new SqlParameter("@ProductBrandID", ((productBrandID != Guid.Empty && productBrandID != null) ? productBrandID : (object)DBNull.Value)));
            parameters.Add(new SqlParameter("@Keyword", (string.IsNullOrEmpty(keyword) ? (object)DBNull.Value : keyword)));

            return SQLHelper.RetrieveObject<ProductBrand>("spGetProductBrand", parameters);
            
        }

        public static List<ProductBrand> GetList(Guid productBrandID, string keyword)
        {
            List<SqlParameter> parameters = new List<SqlParameter>();
            parameters.Add(new SqlParameter("@ProductBrandID", ((productBrandID != Guid.Empty && productBrandID != null) ? productBrandID : (object)DBNull.Value)));
            parameters.Add(new SqlParameter("@Keyword", (string.IsNullOrEmpty(keyword) ? (object)DBNull.Value : keyword)));

            return SQLHelper.RetrieveList<ProductBrand>("spGetProductBrand", parameters);
            
        }

        public static DataTable GetDataTable(Guid productBrandID, string keyword)
        {
            List<SqlParameter> parameters = new List<SqlParameter>();
            parameters.Add(new SqlParameter("@ProductBrandID", ((productBrandID != Guid.Empty && productBrandID != null) ? productBrandID : (object)DBNull.Value)));
            parameters.Add(new SqlParameter("@Keyword", (string.IsNullOrEmpty(keyword) ? (object)DBNull.Value : keyword)));

            return SQLHelper.ExecuteDataTable("spGetProductBrand", parameters);
            
        }

        public static DataSet GetDataSet(Guid productBrandID, string keyword)
        {
            List<SqlParameter> parameters = new List<SqlParameter>();
            parameters.Add(new SqlParameter("@ProductBrandID", ((productBrandID != Guid.Empty && productBrandID != null) ? productBrandID : (object)DBNull.Value)));
            parameters.Add(new SqlParameter("@Keyword", (string.IsNullOrEmpty(keyword) ? (object)DBNull.Value : keyword)));

            return SQLHelper.ExecuteDataSet("spGetProductBrand", parameters);
            
        }

        public static void Save(ProductBrand myProductBrand)
        {
            myProductBrand.Mode = ((myProductBrand.UniqueID != Guid.Empty && myProductBrand.UniqueID != null) ? GlobalConfigurations.Mode.Update : GlobalConfigurations.Mode.Insert);
            myProductBrand.UniqueID = ((myProductBrand.UniqueID != Guid.Empty && myProductBrand.UniqueID != null) ? myProductBrand.UniqueID : Guid.NewGuid());
            if (myProductBrand.Mode == GlobalConfigurations.Mode.Insert)
            {
                myProductBrand.IsActive = true;
            }

            List<SqlParameter> parameters = new List<SqlParameter>();
            parameters.Add(new SqlParameter("@ProductBrandID", myProductBrand.UniqueID));
            parameters.Add(new SqlParameter("@BrandName", (string.IsNullOrEmpty(myProductBrand.BrandName) ? (object)DBNull.Value : myProductBrand.BrandName)));
            parameters.Add(new SqlParameter("@SequenceNo", (myProductBrand.SequenceNo == 0) ? (object)DBNull.Value : myProductBrand.SequenceNo));
            parameters.Add(new SqlParameter("@CreatedBy", ((myProductBrand.UserAccountID != Guid.Empty && myProductBrand.UserAccountID != null) ? myProductBrand.UserAccountID : (object)DBNull.Value)));
            parameters.Add(new SqlParameter("@IsActive", myProductBrand.IsActive));
            //parameters.Add(new SqlParameter("@IsDeleted", myProductCategory.IsDeleted));
            parameters.Add(new SqlParameter("@Mode", myProductBrand.Mode));

            SQLHelper.ExecuteQuery("spAddOrUpdateProductBrand", parameters);
            
        }
    }
}
